/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jtbcore.exception.InvalidArgument;
import jtbcore.model.BaseStringMap;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

public class ObjectUtil {
    public List iteratorToList(Iterator t) {
        ArrayList l = new ArrayList();
        while (t.hasNext()) {
            l.add(t.next());
        }
        return l;
    }

    public static Object castStringToType(String s, Class clazz) throws InvalidArgument {
        if (clazz == Integer.class) {
            return NumberUtil.tryParseInt(s);
        }
        if (clazz == Double.class) {
            return NumberUtil.tryParseDouble(s);
        }
        if (clazz == Boolean.class) {
            if ("1".equals(s) || "true".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s)) {
                return true;
            }
            return false;
        }
        throw new InvalidArgument("Class conversion not implemented: " + String.valueOf(clazz));
    }

    public static Object getObjectValue(Object ref, String propName) {
        Map m;
        BaseStringMap bsm;
        try {
            Method[] meths = ref.getClass().getMethods();
            Object get_func = propName.startsWith("get") ? propName : "get" + StringUtil.camelify(propName);
            Method[] methodArray = meths;
            int n = meths.length;
            int n2 = 0;
            while (n2 < n) {
                Method m2 = methodArray[n2];
                if (m2.getParameterCount() == 0 && ((String)get_func).equalsIgnoreCase(m2.getName())) {
                    Object o = m2.invoke(ref, new Object[0]);
                    return o;
                }
                ++n2;
            }
            String is_func = "is" + StringUtil.camelify(propName);
            Method[] methodArray2 = meths;
            int n3 = meths.length;
            n = 0;
            while (n < n3) {
                Method m3 = methodArray2[n];
                if (m3.getParameterCount() == 0 && is_func.equalsIgnoreCase(m3.getName())) {
                    Object o = m3.invoke(ref, new Object[0]);
                    return o;
                }
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ref instanceof BaseStringMap && (bsm = (BaseStringMap)ref).hasProperty(propName)) {
            return bsm.getProperty(propName);
        }
        if (ref instanceof Map && (m = (Map)ref).containsKey(propName)) {
            return m.get(propName);
        }
        return null;
    }

    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

